﻿/**
 * @fileoverview Add browser action listener
 * 浏览器状态改变时发出事件调用，执行下面绑定的方法 
 * @author sunnyjiang
 * @version 1.1
 */
var browserListener = {};

/**
 * 初始化所有listener
 */
browserListener.init = function() {
	try {
		 // qqbrowser.tabs.onBeforeNavigateAsync.addListener(function(pageId) {
			 // var tab = tabManager.getTabFromPageId(pageId);
			
			// // view.setPageStatus(tab.attr('id'), 'loading'); // 设置状态栏				
		 // });
		
		// 浏览器创建新页面后的通知
		// isActive: 是否激活
		// parentId: 是否前面页面的子页面，根据此添加tab的new样式
		qqbrowser.tabs.onNewPageCreated.addListener(function(url, title, engine, pageId, index, isActive, parentId) { // engine: 0-ie内核,1-webkit
			try {
				if(tabManager.getCount() >= MAX_TAB_COUNT) {
					return;
				}
				var engineAttr = engine == 0 ? 'I' : engine == 1 ? 'W' : 'N';
				
				// 避免第一个tab的初始化问题，如果有第一个tab，并且属性为第一个自己创建的tab，删除
				var tab = tabManager.getCurrentTab();

				if(tabManager.getUrl(tab) == FIRST_SITE_URL) { // '  '为第一个自建tab用于鉴别的url
					tab.remove();
				}

				var tabId = tabManager.newTab2Index(utils.encodeHtml(url), utils.encodeHtml(title), null, engineAttr, index); // 必须encode html
				
				tabManager.setPageId(tabId, pageId);
				
				var tab = tabManager.getTabFromId(tabId);	
				
				// 激活新标签
				if(isActive) {
					tabManager.activeTab(tab);
				} else if(parentId != 0) { // 新后台打开的子页面添加new样式
					tab.addClass('new');
				}
								
			} catch(e) {
				debug('onNewPageCreated error happened!' + e.message);
			}
		});
		
		// 浏览器设置pageId后将pageId赋给tab
		// tabs.onSetPageId.addListener
		qqbrowser.tabs.onSetPageId.addListener(function(tabId, pageId) {
//			alert(tabId + '-' + pageId);
			tabManager.setPageId(tabId, pageId);

			browser.tabs.select(tabId); // 创建后再通知浏览器select相关page
			//browser.extension.builtin.statistics.increase(STATIS_CMD_SWITCH_TAB_BY_MOUSE_CLICK); //鼠标点击切换标签页的次数上报
		});
		
		// 浏览器关闭页面，移除tab
		qqbrowser.tabs.onPageClosed.addListener(function(pageId, selectId, selectIndex, windowId) {
			var tab = tabManager.getTabFromPageId(pageId);
			if(!tab) {
				return;
			}
		//tabManager.removeTab(tab, 1, selectId); // param2: isNotifyBrowser
//		   alert("关闭逻辑");
//		   if ( tabInfo[window.currentPageId - 1] !== undefined) {
//			   	alert("按ctrl+tab切换时有调用这里吗？" + tabInfo[window.currentPageId - 1]);
//				window.tabInfo[window.currentPageId - 1] = undefined;
//				window.currentPageId = -1;
//				window.savePWinfobar.show(false);
//			}
			tabManager.removeTab(tab, 1);
		});

		// 浏览器关闭页面，tab已经删除
		qqbrowser.tabs.onSelectPageId.addListener(function(selectId, selectIndex) {
			var tab = tabManager.getTabFromPageId(selectId);
			var pageId = selectId;
			//tabManager.activeTab(tab);
			tabManager.switchTab(tab);
			
			if (tab.attr("state") === "1") {	//崩溃
				//infobar.setText(infobar.crashText);
				//infobar.showClose(false);
				//infobar.show(true);
				qqbrowser.page.reload(browser.getCurrentPageId());	//直接刷新
			} else if (tab.attr("state") === "2") {	//假死
				infobar.setText(infobar.zombieText);
				infobar.showClose(true);
				window.infobar.refreshButton.show(true);
				window.infobar.show(true);
			} else {
				infobar.show(false);
			}
		});
		
		
		// change url of address input 
		// 客户端tab id从1开始，需要减1
		qqbrowser.tabs.onAddressChanged.addListener(function(pageId, url) {
			try {
				var tab = tabManager.getTabFromPageId(pageId);
				tabManager.setUrl(tab, url);
				
				// 如果tab是当前的tab，地址栏url也需要变化
				if(tabManager.isCurrentTab(tab))
					addressbar.setAddress(url);	
				
				if(tabManager.isActive(tab)) { // 在前台打开页面时才切换焦点
					view.setFocus(url);
				}
			} catch(e) {
				debug('onAddressChanged error happened!' + e.message);
			}
		});
		
		// change tab title
		// 客户端tab id从1开始，需要减1
		qqbrowser.tabs.onTitleChanged.addListener(function(pageId, title) {
			try {
				if(!title)
					title = 'about:blank';
				
				var tab = tabManager.getTabFromPageId(pageId);
				tabManager.setTitle(tab, utils.encodeHtml(title)); // 必须encode html
			} catch(e) {
				debug('onTitleChanged error happened!' + e.message);
			}
		});
		
		// change tab engine, type 0: IE, 1: Webkit, 2: hide for internal page
		qqbrowser.tabs.onCoreTypeChanged.addListener(function(pageId, type) {
			var engineAttr = type == 0 ? 'I' : type == 1 ? 'W' : 'N';
			try {
				var tab = tabManager.getTabFromPageId(pageId);
				view.toggleEngine(tab, engineAttr);
			} catch(e) {
				debug('onCoreTypeChanged error happened!' + e.message);
			}
		});	
		
		// 浏览器调用改变tab前进后退状态
		// @param go & forward: boolean
		qqbrowser.tabs.onTabStatusChanged.addListener(function(pageId, back, forward, tabState) {
			qqbrowser.log.info("crash! " + tabState);
			try {
				var tab = tabManager.getTabFromPageId(pageId);
				tab.attr('back', back).attr('forward', forward).attr("state", tabState);
				
				// 如果是当前tab，立即改变按钮状态
				if(tabManager.isCurrentTab(tab)) {
					view.setBackAndForwardButtonStatus();
					if (tabState === 1) {	// 崩溃
						if (tab.attr("crashCount") == undefined) {
							tab.attr("crashCount", "1");
						} else if (tab.attr("crashCount") === "1") {
							tab.attr("crashCount", "2");
						} 
						
						if (tab.attr("crashCount") === "1") {
							infobar.setText(infobar.crashFirstTimeText);
							infobar.showClose(false);
							window.infobar.refreshButton.show(false);
							window.infobar.show(true);
							qqbrowser.page.reload(browser.getCurrentPageId());	//直接刷新
							setTimeout(function () {
								if (tabManager.isCurrentTab(tab)) {
									window.infobar.show(false);
								}
							}, 5000);
						} else if (tab.attr("crashCount") === "2") {
							infobar.setText(infobar.crashText);
							infobar.showClose(false);
							window.infobar.refreshButton.show(true);
							window.infobar.show(true);
							infobar.crashPage.insert(document.getElementById("page"));
							infobar.crashPage.setText("一二三四五&nbsp;&nbsp;&nbsp;俺要上山打老虎");
						} 
					} else if (tabState === 2) {	// 假死						
						infobar.setText(infobar.zombieText);
						infobar.showClose(true);
						window.infobar.refreshButton.show(true);
						window.infobar.show(true);
					} else {
						if (tab.attr("crashCount") === "1") {
							window.infobar.show(true);
						} else {
							window.infobar.show(false);
							document.getElementById("page").innerHTML = "";
						}
						tab.attr("crashCount", undefined);
						
					}
				}
			} catch(e) {
				debug('onTabStatusChanged error happened!' + e.message);
			}
		});

		// page loading
		// qqbrowser.tabs.onPageLoadStart.addListener(function(pageId, url) {
			// if(!url) { // 有时url会为undefined
				// return;
			// }
			
			// try {
				// //var tab = tabManager.getTabFromPageId(pageId);

				// //tabManager.setLoadingIcon(tab);
				
				// //view.setPageStatus(tab.attr('id'), 'loading', url); // 设置状态栏	
				// return [true];
			// } catch(e) {
				// debug('onTabStatusChanged error happened!' + e.message);
			// }
		// });

		// page loading end
		qqbrowser.tabs.onPageLoadEnd.addListener(function(pageId) {
			try {
				var tab = tabManager.getTabFromPageId(pageId);

				if ('undefined' != typeof(tabManager.loadStatus[pageId].iconTimer_id)){
					clearTimeout(tabManager.loadStatus[pageId].iconTimer_id);
				}
				
//				if ('undefined' != typeof(tabManager.loadStatus[pageId].statusTimer_id)){
//					clearTimeout(tabManager.loadStatus[pageId].statusTimer_id);
//				}

				if ('undefined' != typeof(tabManager.iconMap[pageId])){
					tabManager.setIcon(tab, tabManager.iconMap[pageId]);
				}else{
					tabManager.setDefualtIcon(tab);
				}
				delete tabManager.iconMap[pageId];
				tabManager.loadStatus[pageId].loadEnd = true;
				
				//view.setPageStatus(tab.attr('id'), 'loadend'); // 设置状态栏				
				return [true];
			} catch(e) {
//				debug('onTabStatusChanged error happened!' + e.message);
			}
		});
		
		 // qqbrowser.tabs.onPageLoadError.addListener(function(pageId) {
			 // try {
				 // var tab = tabManager.getTabFromPageId(pageId);

				// // view.setPageStatus(tab.attr('id'), 'loaderror'); // 设置状态栏
				
			 // } catch(e) {
 // //				debug('onTabStatusChanged error happened!' + e.message);
			 // }
		// });

		// set page favicon
		qqbrowser.tabs.onWebIconReady.addListener(function(pageId, url) {
			try {
				if (tabManager.loadStatus[pageId] == true){
					var tab = tabManager.getTabFromPageId(pageId);
					tabManager.setIcon(tab, url);
				}else{
					tabManager.iconMap[pageId] = url;
				}
				
				return [true];
			} catch(e) {
//				debug('onTabStatusChanged error happened!' + e.message);
			}
		});
		
		// hover on link
		qqbrowser.tabs.onStatusTextChange.addListener(function(pageId, nStatusType, url) {
			url = utils.encodeHtml(url);	// url转义
			try {
				var tab = tabManager.getTabFromPageId(pageId);
				switch(nStatusType) {
					case 0:
						view.setPageStatus(tab.attr('id'), 'loadbefore'); // 设置状态栏
						tabManager.setLoadingIcon(tab);
						
						if ('undefined'!=typeof(url) && ''!=url) {
							tabManager.setUrl(tab, url);
							tabManager.setTitle(tab, utils.encodeHtml(url)); // 必须encode html
							if(tabManager.isCurrentTab(tab)) {
								addressbar.setAddress(url);	
							}
						}						
					break;
					case 1:
						tabManager.setLoadingIcon(tab);

						delete tabManager.iconMap[pageId];
						if ('undefined' == typeof(tabManager.loadStatus[pageId])) {
							tabManager.loadStatus[pageId] = {};
						}
						
						if ('undefined' != typeof(tabManager.loadStatus[pageId].iconTimer_id)){
							clearTimeout(tabManager.loadStatus[pageId].iconTimer_id);
						}
				
//						if ('undefined' != typeof(tabManager.loadStatus[pageId].statusTimer_id)){
//							clearTimeout(tabManager.loadStatus[pageId].statusTimer_id);
//						}
						
						tabManager.loadStatus[pageId].loadEnd = false;
						tabManager.loadStatus[pageId].iconTimer_id = 
							setTimeout(function () {

								if (undefined !== tabManager.iconMap[pageId]){
									tabManager.setIcon(tab, tabManager.iconMap[pageId]);
								}else{
									tabManager.setDefualtIcon(tab);
								}
							}, 5000); 
//						tabManager.loadStatus[pageId].statusTimer_id = 
//							setTimeout(function () {
//								view.setPageStatus(tab.attr('id'), 'loadend'); // 设置状态栏
//							}, 10000); 							
						view.setPageStatus(tab.attr('id'), 'loading'); // 设置状态栏
						if ('undefined'!=typeof(url) && ''!=url) {
							tabManager.setUrl(tab, url);
							tabManager.setTitle(tab, utils.encodeHtml(url)); // 必须encode html
							if(tabManager.isCurrentTab(tab)) {
								addressbar.setAddress(url);	
							}
						}	
					break;
					case 2:
						view.setPageStatus(tab.attr('id'), 'loaderror'); // 设置状态栏
					break;
					case 3:
						view.setPageStatus(tab.attr('id'), 'loadend'); // 设置状态栏
					break;
					case 4:
						if ('undefined'==typeof(url) || ''==url) {
							view.showPageStatus(tab.attr('id'));
						} else {
							view.setStatusUrl(url);
						}
					break;
					default:
					break;
				}		
				return [true];
			} catch(e) {
//				debug('onTabStatusChanged error happened!' + e.message);
			}
		});
		
		// 设置aero时
		qqbrowser.os.windows.onDwmCompositionChanged.addListener(function() {
			view.setAero();
		});
		
		// 配置改变时
		qqbrowser.extension.builtin.config.onConfigChanged.addListener(function(config) {
//			debug(config);
			config = eval('(' + config + ')');

			// TODO 检查是否会每个设置都进
			configManager.setView(config);
		});
		
		//环境变化
				
		qqbrowser.account.onEnvironmentChanged.addListener(function(nWindowId, nEnvId, nUin) {

			$('#fav-button').removeClass('fav-button-pressed');
			$('#fav-button').addClass('fav-button');
					
		});
		
		qqbrowser.account.onLoginFinish.addListener(function(){
				
		});
		qqbrowser.account.onLoginFailed.addListener(function(){
				view.stopLogonAnimate();
				view.stopAppAnimate();
				view.initLogoMenu();
		});
		qqbrowser.account.onLogin.addListener(function(nWindowId, nUin, strUin, strNickName, strFacePath) {
			view.stopLogonAnimate();
			view.stopAppAnimate();
			view.showLogonAvatar(strFacePath);
			configManager.init(); // 更新配置
		});
		qqbrowser.account.onLogout.addListener(function(nWindowId) {
			view.initLogoMenu();
			view.stopAppAnimate();
			configManager.init(); // 更新配置
			favbar.setState("stat_ok");
		});
		qqbrowser.account.onUpdate.addListener(function(nWindowId, nUin, strUin, strNickName, strFacePath) {
			view.showLogonAvatar(strFacePath);
			configManager.init(); // 更新配置
		});
		qqbrowser.account.onBeforeLogin.addListener(function(){
			/*
			try{
				qqbrowser.log.info("onBeforeLogin");
			}catch(err){
			}
			*/
			view.startLogonAnimate();
			view.startAppAnimate();															
			//alert("hi");
		});
		// 网络异常
		qqbrowser.account.onConnectFailed.addListener(function(){
			/*
			// 暂时不加了 stefy
			qqbrowser.log.info("connect failed");	
			view.connfailed();
			*/
		});
		// 页面上右键菜单的listener
		qqbrowser.tabs.onBeforeMenu.addListener(function(params) {
			var menuInfo = eval('(' + params + ')');

			var location = { leftBottomX : menuInfo.x, leftBottomY: menuInfo.y, rightTopY: menuInfo.y, rightTopX: menuInfo.x};
			var contentParams = menuInfo;

			var menuParams = {location: location, contentParams: contentParams};
			
			menuManager.showMenu('contentMenu', menuParams);
		});
		
		//  扩展菜单
		qqbrowser.skin.onMenuPopupRequest.addListener(function(windowId, envId, menuId, topLeftX, topLeftY, bottomRightX, bottomRightY) {
			var location = { leftBottomX : topLeftX, leftBottomY: bottomRightY, rightTopY: topLeftY, rightTopX: bottomRightX};
			
			var menuParams = {location: location};
			
			menuManager.showMenuInEnv(envId, menuId, menuParams);	
		});
		
		
		// 撤销列表事件
		qqbrowser.recentclosed.onRemoved.addListener(function(isClean, undoListCount) {
			if(undoListCount == 0) { // 没有撤销列表时，禁用按钮
				view.disableUndoButtons();
			}
		});
		
		qqbrowser.recentclosed.onAdded.addListener(function() {
			// 有撤销列表项目时，启用按钮
			view.enableUndoButtons();
		});
		
		// 浏览器地址栏功能支持
		qqbrowser.addressbar.onSetFocus.addListener(function() {
			view.setFocus2Skin();
		});
		qqbrowser.addressbar.onDropDown.addListener(function() {
			//modified by yinzhou
			if (addressbar.isListShown()) {
				qqbrowser.skin.addressbar.adjustHeight(0);
			}
			else {
				view.setFocus2Skin();
				addressbar.showAddresslist();
			}
		});
		qqbrowser.addressbar.onSelectAllText.addListener(function() {
			view.setFocus2Skin();
			addressbar.selectAllInput();
		});
		
		qqbrowser.skin.setButtonText.addListener(function(buttonGuid, text) {
			view.setButtonText(buttonGuid, text);
		});
		qqbrowser.addressbar.onPlasterOpen.addListener(function(url) {
			browser.tabs.create(url, 1);
		});
		
		qqbrowser.addressbar.onDeleteText.addListener(function() {
			try{
				addressbar.deleteSelectedInput();
			} catch(error){
				alert(error);
			}
			
		});		
		
		// 控制界面按钮状态
		// nStatus值   0-可用；1-禁用；2-隐藏；3-显示；4-选择；5-不选择 
		function onSetButtonStatus(extid, nStatus) {
			if(extid == '{D21B044A-3FDF-4241-865C-5692771BED80}') { // zoom plugin
				if(nStatus == 1) { // disable
					view.setButtonDisabled('zoom-drop-button');
					view.setButtonDisabled('zoom-inner-box');					
				} else if(nStatus == 0) { // enable
					view.setButtonEnabled('zoom-drop-button');
					view.setButtonEnabled('zoom-inner-box');	
					
					eventManager.bindZoomButton();
				}
			} else if(extid == '{87281D86-2185-4656-BF0D-C88478545F4C}') { // screen plugin
				if(nStatus == 1) { // disable
					view.setButtonDisabled('screen-box');				
				} else if(nStatus == 0) { // enable
					view.setButtonEnabled('screen-box');
					
					eventManager.bindScreenButton();					
				} else if(nStatus == 4)	{ // selected
					$('#screen-button').removeClass('unselected');
				} else if(nStatus == 5) { // unselected
					$('#screen-button').addClass('unselected');
				} 
			} else if(extid = '{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}') {
				qqbrowser.log.info("ningzhang nStatus: " + nStatus);
				if(nStatus == 0) { // 松开fav按钮，可以执行点击
					$('#fav-button').removeClass('fav-button-pressed');
					$('#fav-button').addClass('fav-button');
					eventManager.bindFavButton();
				} else if(nStatus == 4) { // 按下fav按钮，点击无效
					$('#fav-button').addClass('fav-button-pressed');
					$('#fav-button').removeClass('fav-button');
					eventManager.unbindFavButton();
				}
			}
		};
		qqbrowser.skin.onSetButtonStatus.addListener(onSetButtonStatus);
		
		// 地址栏下拉显示与否
		qqbrowser.skin.addressbar.onShow.addListener(function(isListShown){
			setTimeout('addressbar.setIsListShown(' + isListShown + ')', 200);
		});	
		
//		BSSI_OK = 0, 状态正常
//		BSSI_DOWNLOADING, 下载中
//		BSSI_DOWNLOAD_ERROR, 下载异常
//		BSSI_UPLOADING , 上传中
//		BSSI_UPLOAD_ERROR, 上传失败		
		// 收藏异常
		qqbrowser.bookmark.onSyncStateChanged.addListener(function(syncStateId) {
			if(syncStateId == 2) {
				//BSSI_DOWNLOAD_ERROR, 下载异常
				// popup bookmark sync dialog
				var obj = {};
				obj.command = "OnShowNotifyDialog";
//				qqbrowser.extension.sendRequest("{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}", obj, function() {});			
				// 记录异常,等用户主动操作后才弹
				favbar.setState("download_err");	
			}else if ( 4 == syncStateId ){  
				//BSSI_UPLOAD_ERROR, 上传失败
			    // 直接弹
				qqbrowser.log.info("upload err");
				var extIdBookmark ="{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
				var cmd = {};
				cmd.command = "showNotify";
				cmd.status="uploadFail";
				qqbrowser.extension.sendRequest(extIdBookmark, cmd, function() {});			
			}else if (0 == syncStateId ){
			    // 情况好了 ， 恢复标志位
				favbar.setState("stat_ok");
			}
			
		});
		
		/* 窗口最大化和还原 */
		qqbrowser.skin.window.onMaximized.addListener(function(windowId) {
			view.toggleMaxAndMinView(true);
		});
		
		qqbrowser.skin.window.onRestored.addListener(function(windowId) {
			view.toggleMaxAndMinView(false);
		});
		
		/**
		 * 焦点相关  
		 **/
		// 皮肤的同步回调。C++需要JS同步处理某些逻辑 toorcliu
		// 参数格式：arg1：命令ID，arg2...argN，具体命令对应的参数

		//	皮肤窗口和JS逻辑是跑在同一个线程里的，它们之间的交互完全可以同步。
		// 以前焦点相关的一些C++ --> JS调用都是异步的，造成时序上的不可控。现在尽量使用同步的方式，这里封装出一个统一的同步调用接口。
		qqbrowser.skin.window.onSyncCallBack.addListener(function(oArgs) {
			var v = eval("("+oArgs+")");			
			if (unescape(v[0]) == "checkFocus")	// 检查是否需要设置焦点
			{
				var element = document.elementFromPoint(v[1], v[2]);
				if(element.id == 'address-input' || element.id == 'address-list-button') { // 地址栏
					addressbar.selectAllInput();
					return 1;
				}
				else if(element.tagName.toLowerCase() == 'iframe')//侧边栏iframe
				{
					return 1;
				}
				return 0;
			}
			else if (unescape(v[0]) == "clearAddressSelectInfo")	//清楚地址栏选中状态
			{
				addressbar.clearSelectionInfo();
				return 1;
			}
		});		
		
		// 焦点设置相关，在皮肤上点击设置焦点到地址栏
		qqbrowser.skin.window.onSetElement.addListener(function(x, y) {
			// 判断，如果是在地址栏，就setfocus
			var element = document.elementFromPoint(x, y);
			
			if(element.id == 'address-input' || element.id == 'address-list-button') {			
				addressbar.focus();
			}
		});		
		
		// 1 表示焦点在皮肤 2表示在页面 0表示无焦点
		qqbrowser.skin.window.onActivate.addListener(function(foucusElement) {
//			debug2(foucusElement);
		});		
		
		// 扩展发过来的消息
		var extIdAutoUpdate = "{3E92C4RD-2264-2g12-9BD8-7351394BAGP3}";

		qqbrowser.extension.onRequest.addListener(function(reqId, sender, request) {
			sender = JSON.parse(sender);
			request = JSON.parse(request);
			var extId = unescape(sender.extId);
			
			// 升级安装进度更新
			if(extId == extIdAutoUpdate) 
			{
				var errorCode = request.errorCode;
				if(errorCode != 0) // 安装失败
				{
					var errorDescription = unescape(request.description);
					view.setUpdateStatus(errorDescription);
				}
				else
				{
					var precent = request.percent;
					view.setUpdateStatus(null, precent);
				}	
			}
			
		});
		
		
		// 密码自动保存扩展发过来的消息
//little		
		var extPWAutoSave = "{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";

		qqbrowser.extension.onEvent.addListener(function(event,data) {
			data = eval('(' + data + ')');
			//alert("hello" + extId + pageId + nickname);
			//var extId = unescape(data[1].extId);
			if (event == 'EventAutoFillTip')
			{
				var pageId = data.pageId;
				var nickname = data.nickname;
				var title = data.title;
				var tempNickname = unescape(unescape(nickname));
				var tempTitle = unescape(unescape(title));
				//savePWinfobar.userText = ' "' + tempNickname  + '" ';
				//savePWinfobar.webpageText = ' "' + tempTitle + '" ';
				//savePWinfobar.setText(savePWinfobar.webpageText);
				savePWinfobar.showClose(true);
				window.savePWinfobar.rememberButton.show(true);
				//savePWinfobar.finalText = "您需要 QQ浏览器 帮您保存此网站的密码吗？";
				//savePWinfobar.setHtml(savePWinfobar.finalText);
				window.savePWinfobar.show(true);
				window.tabInfo[pageId - 1] = [tempNickname, tempTitle];
				window.currentPageId = pageId;
			}			
		}, {evtOwner:'{75A78384-8765-4852-ABB7-8D5FA8BF48E2}'});

		// 关于对话框
		qqbrowser.skin.aboutDialog.addListener(function(windowId) {
			var oParent = {};
			oParent.type = "window";
			oParent.id = windowId;
			qqbrowser.dialog.create(oParent, "aero\\aboutDialog.html", 336 , 268, true, escape("关于 QQ浏览器"), true);
		});
		

		// added by yinzhou
		// 即将触发快捷键时地址栏下拉必须隐藏
		qqbrowser.accelerator.onBeforeTriggerd.addListener(function(acceleratorKey) {
			browser.skin.addressbar.adjustHeight(0);
		});
		
		//检查升级对话框
		qqbrowser.extension.builtin.onCheckUpdate.addListener(function(windowId) {
			var obj = {};
			obj.paramone = '1';
			obj.command = "OnManualCheckUpdate";
			try {
				qqbrowser.extension.sendRequest("{3E92C4RD-2264-2g12-9BD8-7351394BAGP3}", obj , 
				function(reply) {
				});
			} catch(err){
			}
		});

	} catch(e) {
		// do nothing for html static development
		//alert(e.message);
	}
};
